/** @type {import('tailwindcss').Config} */

// Get settings from shopify themes editor
const colors = require('tailwindcss/colors')

module.exports = {
    content: [
        "../Resources/Private/**/*.{html,js}",
        "../Configuration/**/*.yaml",
        "node_modules/preline/dist/*.js"
    ],
    safelist: ['text-4xl', 'font-bold', 'font-heading'],

    theme: {
        container: {
            center: true,
        },
        extend: {
            fontFamily: {
                body: ['var(--font-body-family)'],
                heading: ['var(--font-heading-family)']
            },
            colors: {
                primary: 'oklch(var(--color-primary) / <alpha-value>)',
                primary_fallback: 'rgb(var(--color-primary-fallback) / <alpha-value>)',
                secondary: 'oklch(var(--color-secondary) / <alpha-value>)',
                secondary_fallback: 'rgb(var(--color-secondary-fallback) / <alpha-value>)'
            },
            maxWidth: {
                unset: 'unset'
            },
            maxHeight: {
                unset: 'unset'
            },
            animation: {
                backdropPlörr: 'backdropPlörr 1000ms cubic-bezier(0.16, 1, 0.3, 1) forwards',
                backdropFade: 'backdropFade 500ms cubic-bezier(0.16, 1, 0.3, 1) forwards',
            },
            keyframes: {
                backdropPlörr: {
                    'from': {
                        transform: 'translate(-50%, -100%) scale(.001)',
                        opacity: '0'
                    },

                    'to': {
                        transform: 'translate(-50%, -50%) scale(1)',
                        opacity: '1'
                    },

                },
                backdropFade: {
                    'from': {
                        opacity: '0'
                    },

                    'to': {
                        opacity: '1'
                    },

                }

            },
            typography: ({theme}) => ({
                light: {
                    css: {
                        '--tw-prose-body': theme('colors.zinc[100]'),
                        '--tw-prose-headings': theme('colors.zinc[100]'),
                        '--tw-prose-lead': theme('colors.zinc[100]'),
                        '--tw-prose-links': theme('colors.zinc[100]'),
                        '--tw-prose-bold': theme('colors.zinc[100]'),
                        '--tw-prose-counters': theme('colors.zinc[100]'),
                        '--tw-prose-bullets': theme('colors.zinc[100]'),
                        '--tw-prose-hr': theme('colors.zinc[100]'),
                        '--tw-prose-quotes': theme('colors.zinc[100]'),
                        '--tw-prose-quote-borders': theme('colors.zinc[100]'),
                        '--tw-prose-captions': theme('colors.zinc[100]'),
                        '--tw-prose-code': theme('colors.zinc[100]'),
                        '--tw-prose-pre-code': theme('colors.zinc[100]'),
                        '--tw-prose-pre-bg': theme('colors.zinc[100]'),
                        '--tw-prose-th-borders': theme('colors.zinc[100]'),
                        '--tw-prose-td-borders': theme('colors.zinc[100]'),
                        '--tw-prose-invert-body': theme('colors.zinc[100]'),
                        '--tw-prose-invert-headings': theme('colors.white'),
                        '--tw-prose-invert-lead': theme('colors.zinc[100]'),
                        '--tw-prose-invert-links': theme('colors.white'),
                        '--tw-prose-invert-bold': theme('colors.white'),
                        '--tw-prose-invert-counters': theme('colors.zinc[100]'),
                        '--tw-prose-invert-bullets': theme('colors.zinc[100]'),
                        '--tw-prose-invert-hr': theme('colors.zinc[100]'),
                        '--tw-prose-invert-quotes': theme('colors.zinc[100]'),
                        '--tw-prose-invert-quote-borders': theme('colors.zinc[100]'),
                        '--tw-prose-invert-captions': theme('colors.zinc[100]'),
                        '--tw-prose-invert-code': theme('colors.white'),
                        '--tw-prose-invert-pre-code': theme('colors.zinc[100]'),
                        '--tw-prose-invert-pre-bg': 'rgb(0 0 0 / 50%)',
                        '--tw-prose-invert-th-borders': theme('colors.zinc[100]'),
                        '--tw-prose-invert-td-borders': theme('colors.zinc[100]'),
                    },
                },
            }),
        },
    },
    plugins: [
        require('@tailwindcss/typography'),
        require('@tailwindcss/forms'),
        require('tailwindcss-animatecss'),
        require('preline/plugin'),
    ]
}

