<?php

namespace Amadeus\Mod\Schwarzbach;

use Amadeus\Core\Traits\PostTypes;
use Amadeus\Core\Traits\Template;
use Amadeus\Core\Traits\Updater;

class Main
{
    use Updater;
    use Template;
    use PostTypes;

    public static function init($mainFile)
    {
        self::$PLUGIN_PATH = plugin_dir_path($mainFile);
        self::registerUpdater();

        self::registerFilters();
    }

    public static function registerJobTemplate($args)
    {
        return self::$PLUGIN_PATH . '/views/shortcode-stellenangebote.twig';
    }


    public static function registerFilters()
    {
        add_action('amadeus_postTypes_init', [__CLASS__, "registerPostTypes"]);


        add_filter('amadeus_job_template', [__CLASS__, 'registerJobTemplate']);
    }

    function populateJobField($field, $form)
    {

        if ($field['slug'] == 'stellenangebot') {

            $args = [
                'post_type' => 'job',
                'posts_per_page ' => -1,
                'post_status' => 'publish'
            ];

            $query = new \WP_Query($args);

            $preSelect = isset($_GET['jobs']) ? $_GET['jobs'] : -1;

            $field['config']['default'] = $preSelect;

            $field['config']['option'] = [];
            $field['config']['option'][] = ['value' => 'Initiativbewerbung', 'label' => 'Initiativbewerbung'];


            foreach ($query->get_posts() as $k => $post) {
                $category = get_the_terms($post->ID, 'kategorie');
                if ($category[0]->slug == "ausbildungsstellen") {
                    $post->post_title = "Ausbildung " . $post->post_title;
                }

                $field['config']['option'][$post->ID] = ['value' => $post->post_title, 'label' => $post->post_title];
            }
        }
        return $field;

    }


}
