<?php


namespace Amadeus\Mod\Magazin;

use Amadeus\Core\Shortcode;
use Amadeus\Core\Traits\PostTypes;
use Amadeus\Core\Traits\TimberLocation;
use Amadeus\Core\Traits\Updater;

use Timber\Timber;
use Timber\User;
use Timber\Term;
use Timber\Image as TimberImage;



class Main
{
    use Updater;
    use PostTypes;
    use TimberLocation;

    public static function init($main_path = __FILE__)
    {
        self::$PLUGIN_PATH = plugin_dir_path($main_path);

        self::registerUpdater();
        self::registerTimberLocation();
        self::registerShortcode();


        add_action('amadeus_PostTypes_init', [__CLASS__, 'registerPostTypes']);
        add_action('caldera_forms_submit_complete', [__CLASS__, 'classifiedScheduler']);
        add_action('wp_enqueue_scripts', [__CLASS__, 'weatherFont']);
        add_action('init', [__CLASS__, 'disable_wp_emojicons']);

        add_action('save_post', [__CLASS__, 'changeCalendarTitle'], 13);

        register_activation_hook(__FILE__, [__CLASS__, '__activate']);

        add_action('amadeus_cron_weather', [__CLASS__, 'getWeatherInfo']);
    }

    public static function __activate()
    {
        if (!wp_next_scheduled('amadeus_cron_weather')) {
            wp_schedule_event(time(), 'hourly', 'amadeus_cron_weather');
            wp_schedule_event(time() + 15 * 60, 'hourly', 'amadeus_cron_weather');
            wp_schedule_event(time() + 30 * 60, 'hourly', 'amadeus_cron_weather');
            wp_schedule_event(time() + 45 * 60, 'hourly', 'amadeus_cron_weather');
        }
    }


    public static function classifiedScheduler()
    {

    }

    public static function disable_wp_emojicons()
    {
// all actions related to emojis
        remove_action('admin_print_styles', 'print_emoji_styles');
        remove_action('wp_head', 'print_emoji_detection_script', 7);
        remove_action('admin_print_scripts', 'print_emoji_detection_script');
        remove_action('wp_print_styles', 'print_emoji_styles');
        remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
        remove_filter('the_content_feed', 'wp_staticize_emoji');
        remove_filter('comment_text_rss', 'wp_staticize_emoji');

// filter to remove TinyMCE emojis
//        add_filter('tiny_mce_plugins', 'disable_emojicons_tinymce');
        add_filter('emoji_svg_url', '__return_false');

    }


    public static function registerShortcode()
    {
        new Shortcode('weather', [__CLASS__, "weatherShortcode"]);
        new Shortcode('quickcontact', [__CLASS__, "quickContactShortcode"]);
        new Shortcode('userinfo', [__CLASS__, "userInfoShortcode"]);
        new Shortcode('classifieds', [__CLASS__, "classifieds"]);
        new Shortcode('pdfarchive', [__CLASS__, "showPDFArchive"]);
        new Shortcode('getnextmagrelease', [__CLASS__, "getNextMagazineRelease"]);
        new Shortcode('apothekenbereitschaft', [__CLASS__, "getApothekenbereitschaft"]);
        new Shortcode('kindernotdienste', [__CLASS__, "getKinderNotdienste"]);
    }


    public static function getApothekenbereitschaft()
    {
        $day         = date('w');
        $week_start  = date('Y-m-d', strtotime('-' . $day . ' days'));
        $twoweek_end = date('Y-m-d', strtotime('+' . (13 - $day) . ' days'));


        $context['events'] = Timber::get_posts([
            "post_type" => "event",
            "event-type" => "Apothekenbereitschaft",
            'meta_query' => [
                [
                    'key' => 'beginn',
                    'value' => $week_start,
                    'compare' => '>=',
                    "type" => 'DATE'
                ],
                [
                    'key' => 'beginn',
                    'value' => $twoweek_end,
                    'compare' => '<=',
                    "type" => 'DATE'
                ]
            ],
            'orderby' => 'meta_value',
            'order' => 'ASC'
        ]);

//        if ($_SERVER['REMOTE_ADDR'] == '87.138.162.211') var_dump($context);

        return Timber::compile('notdienst.twig', $context);
    }

    public static function getKinderNotdienste()
    {
        $day         = date('w');
        $week_start  = date('Y-m-d', strtotime('-' . $day . ' days'));
        $twoweek_end = date('Y-m-d', strtotime('+' . (13 - $day) . ' days'));


        $context['events'] = Timber::get_posts([
            "post_type" => "event",
            "event-type" => "Kindernotdienst",
            'posts_per_page' => 3,
            'meta_query' => [
	            [
		            'key' => 'beginn',
		            'value' => $twoweek_start,
		            'compare' => '>=',
		            "type" => 'DATE'
	            ]
            ],
            'orderby' => 'meta_value',
            'order' => 'ASC'
        ]);

        #if ($_SERVER['REMOTE_ADDR'] == '87.138.162.211') var_dump($context);

        return Timber::compile('kindernotdienst.twig', $context);
    }

    public static function getNextMagazineRelease()
    {
        $anzeigenschluss = Timber::get_post([
            'post_type' => 'event',
            'post_status' => 'publish',
            'posts_per_page' => 1,
            'event-type' => 'Amadeus Anzeigenschluss',
            'meta_key' => 'beginn',
            'meta_query' => [
                [
                    'key' => 'beginn',
                    'value' => date("Y-m-d H:i:s"),
                    'compare' => '>=',
                    "type" => 'DATE'
                ]
            ],
            'orderby' => 'meta_value',
            'order' => 'ASC'

        ]);

        $erscheinungsdatum = Timber::get_post([
            'post_type' => 'event',
            'post_status' => 'publish',
            'posts_per_page' => 1,
            'event-type' => 'Amadeus Erscheinung',
            'meta_key' => 'beginn',
            'meta_query' => [
                [
                    'key' => 'beginn',
                    'value' => date("Y-m-d H:i:s", strtotime($anzeigenschluss->beginn)),
                    'compare' => '>=',
                    "type" => 'DATE'
                ]
            ],
            'orderby' => 'meta_value',
            'order' => 'ASC'

        ]);

        return '<b>' . date('d.m.Y', strtotime($erscheinungsdatum->beginn)) . '</b> in ' . str_replace('Erscheinung ', '', $erscheinungsdatum->post_title);


    }

    public static function weatherFont()
    {
        wp_enqueue_style('owfont', get_stylesheet_directory_uri() . '/static/css/owfont-regular.min.css');
    }

    public static function weatherShortcode()
    {


        /* TODO:
        - wäre es nich besser das im transient cache zu speichern?
        - fehler bei ungültiger antwort von owm api abfangen
        */

        $json = get_transient('weather.cache');

        $json = json_decode($json);

        if ($json !== false && is_object($json) && $json->cod == 200) {
            $date = time();

            $n = '-n';
            if ($date > date_sunrise($date, SUNFUNCS_RET_TIMESTAMP) && $date < date_sunset($date,
                    SUNFUNCS_RET_TIMESTAMP)
            ) {
                $n = '-d';
            }
// Json will give you Kelvin. Which is offset by 273.15 to Celcius
            return '<span><i class="owf owf-lg owf-' . $json->weather[0]->id . $n . '" title="' . $json->weather[0]->description . '" data-weathercondition="'.$json->weather[0]->id.'"></i>&nbsp;' . (int)($json->main->temp - 273.15) . ' °C </span>';
        } else {
            return '';
        }
    }


    public static function quickContactShortcode($atts)
    {
        extract(shortcode_atts(array(
            'id' => 1,
        ), $atts));

        $context = [];

        $context['user'] = new User($id);

        return Timber::compile('quickcontact.twig', $context);

    }

    public static function userInfoShortcode($atts)
    {
        extract(shortcode_atts(array(
            'id' => 1,
        ), $atts));

        $context = [];

        $context['user'] = new User($id);
        $context['user_img'] = new TimberImage($context['user']->get_meta_field('user_img'));

        return Timber::compile('userinfo.twig', $context);

    }

    public static function classifieds($atts)
    {
        $context = [];
        $context['terms'] = Timber::get_terms('classified_category');
        return Timber::compile('archive-classifieds.twig', $context);

    }

    public static function getWeatherInfo()
    {
        $apiKey = '4484a072ba4b40721ff6679065587500';
        $locationId = '2831250';
        $url = 'http://api.openweathermap.org/data/2.5/weather?id=' . $locationId . '&lang=de&APPID=' . $apiKey;


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        $output = curl_exec($ch);


        $outputObj = json_decode($output);


        if ($outputObj !== false && is_object($outputObj) && $outputObj->cod == 200) {
            set_transient('weather.cache', $output, 30 * 60);
        }

        curl_close($ch);

        return;
    }

    public static function classified_layout_export()
    {

//FUCKING BOOTSTRAP SHORTCODES IS MESSING WITH THE OUTPUT SO STFU or GTFO
        global $wp_filter;
        unset($wp_filter['the_post']->callbacks['9999']);

        $context = [];
        $context['terms'] = Timber::get_terms('classified_category');


        Timber::render('layout-export.twig', $context);
    }

    public static function changeClassifiedTitle($post_id)
    {
        global $wpdb;
        $post = get_post($post_id);

        if ($post->post_type == "classified" && $post->post_status == "draft") {
            remove_action('save_post', ['Amadeus_Mod_Magazin', 'changeClassifiedTitle']);

            $sql = 'Select meta_value from wp_postmeta where meta_key="kaz_ID" order by meta_value DESC Limit 0,1';

            $highestId = $wpdb->get_var($sql);

            $highestId++;

            update_post_meta($post_id, 'kaz_ID', $highestId);

// update the post, which calls save_post again
            wp_update_post(array('ID' => $post_id, 'post_title' => date('Ymd') . '-' . $highestId, 'post_status' => 'pending'));

// re-hook this function
            remove_action('save_post', ['Amadeus_Mod_Magazin', 'changeClassifiedTitle'], 12);
        }
    }

    public static function changeCalendarTitle($post_id)
    {
        global $wpdb;

        $post = get_post($post_id);

        if ($post->post_type == "event" && $post->post_title == "") {

            $postTerm = wp_get_post_terms($post_id, "event-type");

            switch ($postTerm[0]->term_id) {

                //Apothekenbereitschaft
                case 621:
                    {
                        $begin = get_post_meta($post_id, 'beginn', true);

                        $postTitle = "ERROR!";
                        if ($begin != 0) {
                            $postTitle = "Apothekenbereitschaft " . date('d.m.Y', strtotime($begin));
                        }
// update the post, which calls save_post again
                        wp_update_post(array('ID' => $post_id, 'post_title' => $postTitle, "post_name" => sanitize_title($postTitle)));

                        remove_action('save_post', ['Amadeus_Mod_Magazin', 'changeCalendarTitle'], 13);
                        break;
                    }
            }

            remove_action('save_post', ['Amadeus_Mod_Magazin', 'changeCalendarTitle'], 13);
        }
    }

    public static function showPDFArchive($shortcode_attributes)
    {
        /**
         * @var $limit
         * @var $category
         */
        extract(shortcode_atts(array(
            'category' => 'all',
            'limit' => -1,
        ), $shortcode_attributes));

        $context = [];

        $context['pdf'] = Timber::get_posts(['post_type' => 'dflip', 'post_status' => 'publish', 'posts_per_page' => $limit]);

        return Timber::compile(['pdf-archive.twig'], $context);
    }

}
