<?php
/**
 * Created by PhpStorm.
 * User: jfschubert
 * Date: 30.11.16
 * Time: 16:07
 */


$names = [
    "post_type_name" => "jobad",
    "singular" => "Stellenmarkt",
    "plural" => "Stellenmarkt",
    "slug" => "stellenmarkt"
]
;
$options = ['supports' => array('title', 'thumbnail'), 'has_archive' => true]
;
$jobad = new \Amadeus\Core\PostType\PostType($names, $options);

$jobad->columns(array(
    'cb' => '<input type="checkbox" />',
    'title' => __('Title'),
    'ad_expiration' => __('Sichtbar bis'),
    'date' => __('Date')
));


$jobad->populate_column('ad_expiration', function($column, $post) {
    echo "" .date('d.m.Y',strtotime(get_field('ad_expiration')));
});


if( function_exists('acf_add_local_field_group') ):

    acf_add_local_field_group(array (
        'key' => 'group_58515db536350',
        'title' => 'Job-Ad Options',
        'fields' => array (
            array (
                'key' => 'field_58515e7612c4e',
                'label' => 'Anzeigen bis',
                'name' => 'ad_expiration',
                'type' => 'date_picker',
                'instructions' => 'die Anzeige wird angezeigt bis zu diesem Datum',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array (
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'display_format' => 'd.m.Y',
                'return_format' => 'Ymd',
                'first_day' => 1,
            ),
            array (
                'key' => 'field_589ae226676e5',
                'label' => 'Stellen:',
                'name' => 'jobs',
                'type' => 'repeater',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array (
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'min' => 0,
                'max' => 0,
                'layout' => 'table',
                'button_label' => '',
                'collapsed' => '',
                'sub_fields' => array (
                    array (
                        'key' => 'field_589ae23f676e6',
                        'label' => 'Stelle',
                        'name' => 'job_title',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array (
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => 'Job Bezeichnung ( m / w)',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'jobad',
                ),
            ),
        ),
        'menu_order' => 6,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'left',
        'instruction_placement' => 'label',
        'hide_on_screen' => array (
            0 => 'permalink',
            1 => 'excerpt',
            2 => 'discussion',
            3 => 'comments',
            4 => 'author',
            5 => 'send-trackbacks',
        ),
        'active' => 1,
        'description' => '',
    ));

endif;