<?php
/**
 * Created by PhpStorm.
 * User: jfschubert
 * Date: 30.11.16
 * Time: 16:07
 */


$names = [
    "post_type_name" => "classified",
    "singular" => "Kleinanzeige",
    "plural" => "Kleinanzeigen",
    "slug" => "kleinanzeige"
];
$options = ['has_archive' => true];

$classified = new \Amadeus\Core\PostType\PostType($names,$options);

$classified->register_taxonomy('classified_category');

add_submenu_page( 'edit.php?post_type=classified', 'Layout Export', 'Layout Export', 'edit_pages', 'layout', ['Amadeus\\Mod\\Magazin\\Main','classified_layout_export'],11);

$classified->columns(array(
    'cb' => '<input type="checkbox" />',
    'title' => __('Title'),
    'classified_category' => __('Rubrik'),
    'content' => __('Inhalt'),
    'client' => __('Kunde'),
    'cipher' => __('Chiffre'),
    'kaz_duration' => __('Ausgaben'),
    'date' => __('Date')
));

$classified->populate_column('content', function($column, $post) {
    echo "" .$post->post_content;
});
$classified->populate_column('client', function($column, $post) {
    echo "" .get_field('kaz_forename')." ".get_field('kaz_surname');
});
$classified->populate_column('cipher', function($column, $post) {
    echo "" .get_field('kaz_cipher');
});
$classified->populate_column('kaz_duration', function($column, $post) {
    echo "" .get_field('kaz_duration');
});
$classified->add_action('save_post',['Amadeus_Mod_Magazin','changeClassifiedTitle'],12);