<?php

namespace Amadeus\Core;

use Amadeus\Core\Page\DefaultSettings;
use Amadeus\Core\Traits\Updater;

class Core
{
    use Updater;


    private static $settingsPage;

    /**
     * @var autoloader
     * @deprecated
     */
    private static $autoloader;

    public static function init()
    {
        add_action('init', [__CLASS__, 'onInit'], 1);
        add_action('admin_init', [__CLASS__, 'onAdminInit'], 1);
        add_action('tgmpa_register', [__CLASS__, 'registerPluginRecommendations']);
        add_action('admin_menu', [__CLASS__, 'onAdminMenu']);
        add_action('wp_head', [__CLASS__, 'onWPHead'], 1);

    }

    public static function onAdminInit()
    {
        self::$settingsPage = new DefaultSettings();

        self::$PLUGIN_PATH = AA_CORE_PATH;

        self::registerUpdater();
    }

    public static function onInit()
    {
        self::registerPostTypes();

    }


    public static function onAdminMenu()
    {
        add_menu_page('amadeus Core-Settings', 'amadeus', 'delete_posts', 'amadeus-core-settings', [__CLASS__, 'pluginPage'], 'dashicons-amadeus');
    }

    /**
     * @param $namespace
     * @param $dir
     * @deprecated
     */
    public static function addAutoload($namespace, $dir)
    {
        echo $namespace . ' = ' . $dir;
    }


    public static function pluginPage()
    {
        self::$settingsPage->getOptionPage();
    }


    public static function registerPostTypes()
    {
        do_action('amadeus_PostTypes_init');
        do_action('amadeus_PostTypes_loaded');
    }

    public static function registerPluginRecommendations()
    {
        include 'tgm/tgm.php';
    }

    public static function onWPHead()
    {
        $cookieConsent = self::getCookie('cookieControlPrefs');

        if (stripos($cookieConsent,'Analytics')) {

            $tracking = get_option('amadeus_analytics') ?? null;
            if ($tracking['propertyID'] != null) {
                ?>
                <!-- Global site tag (gtag.js) - Google Analytics -->
                <!-- anonymized IPs enabled -->
                <script async
                        src="https://www.googletagmanager.com/gtag/js?id=<?php echo $tracking['propertyID'] ?>"></script>
                <script>
                    window.dataLayer = window.dataLayer || [];

                    function gtag() {
                        dataLayer.push(arguments);
                    }

                    gtag('js', new Date());

                    gtag('config', '<?php echo $tracking['propertyID'] ?>', {'anonymize_ip': true});
                </script>

                <?php
            }

            if ($tracking['gtmID'] != null) {
                ?>
                <!-- Google Tag Manager -->
                <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                            new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
                        j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
                        'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
                    })(window,document,'script','dataLayer','<?php echo $tracking['gtmID'] ?>');
                </script>
                <!-- End Google Tag Manager -->
                <?php
            }
        }
    }

    public static function getCookie($cname) {
        if (!isset($_COOKIE[$cname])) {
            return "";
        } else {
            return $_COOKIE[$cname];
        }
    }
}
