<?php

namespace Amadeus\Core\Page;

if (!defined('ABSPATH')) exit;

class DefaultSettings
{

    private $page;

    function __construct()
    {

        $this->page = new Settings();
        add_action('admin_init', [$this, 'onAdminInit']);
    }

    function onAdminInit()
    {
//set the settings
        $this->page->set_sections($this->getSettingsSection());
        $this->page->set_fields($this->getSettingsFields());
//initialize settings
        $this->page->admin_init();
    }

    function getSettingsSection()
    {
        $sections = [
            [
                'id' => 'amadeus_about',
                'title' => __('Über amadeus', 'amadeus')
            ],
            [
                'id' => 'amadeus_analytics',
                'title' => __('Google Analytics', 'amadeus')
            ]
        ];
        return $sections;
    }

    /**
     * Returns all the settings fields
     *
     * @return array settings fields
     */
    function getSettingsFields()
    {
        $settings_fields = [
            'amadeus_analytics' => [
                [
                    'name' => 'propertyID',
                    'label' => __('Universal Analytics ID', 'amadeus'),
                    'type' => 'text'
                ],
                [
                    'name' => 'gtmID',
                    'label' => __('Google Tag Manager ID', 'amadeus'),
                    'type' => 'text'
                ],
            ]
        ];
        return $settings_fields;
    }

    function getOptionPage()
    {
        echo '<div class="wrap">';
        $this->page->show_navigation();
        $this->page->show_forms();
        echo '</div>';
    }

    /**
     * Get all the pages
     *
     * @return array page names with key value pairs
     */
    function get_pages()
    {
        $pages         = get_pages();
        $pages_options = [];
        if ($pages) {
            foreach ($pages as $page) {
                $pages_options[$page->ID] = $page->post_title;
            }
        }
        return $pages_options;
    }
}
