<?php

if (is_file(__DIR__ . DS . 'vendor/autoload.php')) {
    require __DIR__ . DS . 'vendor/autoload.php';
} else {
//    require 'vendor/autoload.php';
}


if (!function_exists('amds_autoloader')) {

    function amds_autoloader($classname)
    {
        $classname = explode("\\", strtolower($classname));

        $include = WP_PLUGIN_DIR . DIRECTORY_SEPARATOR;

        // Nicht amadeus nicht unsere baustelle !
        if ($classname[0] != "amadeus") return;

        if ($classname[1] == 'core') $include .= 'amadeus-core/src/';

        if ($classname[1] == 'mod') {
            $include .= 'amadeus-mod-' . $classname[2] . '/src/';
            unset($classname[2]);
        }

        if ($classname[1] == 'plugin') {
            $include .= 'amadeus-plugin-' . $classname[2] . '/src/';
            unset($classname[2]);
        }

        if ($classname[1] == 'theme') {
            // = nicht .= wegen absuluter pfad
            $include = get_template_directory() . '/src/';
            unset($classname[2]);
        }

        unset($classname[0]);
        unset($classname[1]);

        $include .= implode(DIRECTORY_SEPARATOR, $classname);
        $include .= '.php';

        
        include $include;
    }

    spl_autoload_register('amds_autoloader');
}