<?php

namespace Amadeus\Core\Traits;

/**
 * Created by PhpStorm.
 * User: jfschubert
 * /20Date: 08.12.16
 * Time: 12:04
 */
use Timber\Timber;

trait Template
{

    private static $registeredPostTypes = [];

    public static function loadArchiveTemplate($archive)
    {
        global $wp_query, $post;

        /* Checks for archive template by post type */
        if (in_array($post->post_type, self::$registeredPostTypes)) {
            if (file_exists(self::$PLUGIN_PATH . '/archive-' . $post->post_type . '.php')) {
                Timber::$locations = array(self::$PLUGIN_PATH . '/views');
                return self::$PLUGIN_PATH . '/archive-' . $post->post_type . '.php';
            }
        }
        return $archive;
    }

    public static function loadSingleTemplate($single)
    {
        global $wp_query, $post;
        /* Checks for archive template by post type */
        if (in_array($post->post_type, self::$registeredPostTypes)) {
            if (file_exists(self::$PLUGIN_PATH . '/single-' . $post->post_type . '.php')) {
                Timber::$locations = array(self::$PLUGIN_PATH . '/views');
                return self::$PLUGIN_PATH . '/single-' . $post->post_type . '.php';
            }

        }
        return $single;
    }

}