<?php

namespace Amadeus\Core\Traits;

use Amadeus\Core\Utilities\BlockType;

/**
 * Created by PhpStorm.
 * User: jfschubert
 * Date: 07.03.17
 * Time: 16:13
 */
trait GutenbergBlocks
{
    function registerGutenbergBlock($name, callable $callBack, $blockType = BlockType::Dynamic)
    {
        if(!function_exists('register_block_type')) return;

        switch ($blockType) {
            case BlockType::Dynamic:
                {
                    $scriptname = 'amds-' . $name;

                    wp_register_script(
                        $scriptname,
                        get_stylesheet_directory_uri() . '/blocks/' . $scriptname . '/block.js',
                        ['wp-blocks', 'wp-element']
                    );

                    register_block_type('amds-blocks/' . $name, [
                        'editor_script' => $scriptname,
                        'render_callback' => $callBack,
                    ]);
                    break;
                }

            default:
                break;
        }
    }
}